<?

/*

SMS Archiver for Siemens Phones v0.1
(c) Richard Low 2004
www.wentnet.com
richard@wentnet.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*
  vcard.php

  This file parses a file of vcard format to find a full name for a phone number

  Function getName returns the name for a given phone number.  Returns the phone number if no name is found.

  Set the variable $filename below to the filename of your vcf file.
*/

$filename = "/Users/richard/phone/phonebook/cards.vcf";

$contents = file_get_contents($filename);

function getName($number)
{
  global $contents, $debug;

  define("VCARD_START", "BEGIN:VCARD");
  define("VCARD_END", "END:VCARD");
  define("FULLNAME_TAG", "FN:");

  $number_pos = strpos($contents, $number);

  if ($number_pos === false)
    return $number;

  // find end of vcard
  $end = strpos($contents, VCARD_END, $number_pos);
  // find start
  $start = strlen($contents) - strpos(strrev($contents), strrev(VCARD_START), strlen($contents) - $number_pos);

  if ($debug)
    echo "Start: $start, End: $end\n";

  $data = substr($contents, $start, $end-$start);

  if ($debug)
    echo $data;

  $fnpos = strpos($data, FULLNAME_TAG);
  if ($fnpos === false)
    return $number;

  $end = strpos($data, "\n", $fnpos);
  $name = substr($data, $fnpos + strlen(FULLNAME_TAG), $end - $fnpos - strlen(FULLNAME_TAG) - 1);
  if ($debug)
    echo "Start: $fnpos, End: $end\n";

  return $name;
}

?>