//
//  DataFile.m
//  XNJB
//
//  Created by Richard Low on Sat Aug 21 2004.
//

#import "DataFile.h"
#import "FilesizeFormatter.h"
#import "MyMutableArray.h"

@implementation DataFile

/* returns a datafile representing the file at path
 */
+ (DataFile *)dataFileFromPath:(NSString *)path
{
	DataFile *dataFile = [[DataFile alloc] init];
	[dataFile setFullPath:path];
	[dataFile setFilename:[path lastPathComponent]];
	NSFileManager *fileManager = [[NSFileManager alloc] init];
	NSDictionary *fileAttributes = [fileManager fileAttributesAtPath:path traverseLink:YES];
	if (fileAttributes == nil)
	{
		NSLog(@"Cannot read file %@", path);
		[dataFile release];
		return nil;
	}
	// max file size is 2GB or 31bits. So unsigned int is ok
	[dataFile setSize:[[fileAttributes objectForKey:NSFileSize] unsignedIntValue]];
	//	[dataFile setTimestamp:[fileAttributes objectForKey:NSFileModificationDate]];
	return [dataFile autorelease];
}

// init/dealloc methods

- (void)dealloc
{
	[filename release];
//	[timestamp release];
	[fullPath release];
	[super dealloc];
}

// accessor methods

- (void)setSize:(unsigned)newSize
{
	size = newSize;
}

- (unsigned)size
{
	return size;
}

- (void)setFilename:(NSString *)newFilename
{
	// get immutable copy
	newFilename = [newFilename copy];
	[filename release];
	filename = newFilename;
}

- (NSString *)filename
{
	return filename;
}

- (void)setFileID:(unsigned)newFileID
{
	fileID = newFileID;
}

- (unsigned)fileID
{
	return fileID;
}

- (NSString *)sizeString
{
	return [FilesizeFormatter filesizeString:size];
}

- (void)setFullPath:(NSString *)newFullPath
{
	newFullPath = [newFullPath copy];
	[fullPath release];
	fullPath = newFullPath;
}

- (NSString *)fullPath
{
	return fullPath;
}

/*- (void)setTimestamp:(NSDate *)newTimestamp
{
	[newTimestamp retain];
	[timestamp release];
	timestamp = newTimestamp;
}

- (void)setTimestampSince1970:(unsigned int)newTimestamp
{
	[self setTimestamp:[NSDate dateWithTimeIntervalSince1970:newTimestamp]];
}

- (NSDate *)timestamp
{
	return timestamp;
}

- (NSString *)timestampString
{
	return [timestamp descriptionWithCalendarFormat:@"%Y-%m-%d %H:%M:%S" timeZone:[NSTimeZone timeZoneForSecondsFromGMT:0] locale:nil];
}*/

/**********************/

- (BOOL)matchesString:(NSString *)search
{
	NSRange result = [filename rangeOfString:search options:NSCaseInsensitiveSearch];
	if (result.location == NSNotFound)
	{
	  return NO;
	}
	return YES;	
}

// comparison methods

+ (SEL)compareBySizeSelector
{
	return @selector(compareBySize:);
}

+ (SEL)compareByFilenameSelector
{
	return @selector(compareByFilename:);
}

+ (SEL)compareByTimestampSelector
{
	return @selector(compareByTimestamp:);
}

- (NSComparisonResult)compareBySize:(DataFile *)other
{
	return [self compareUnsignedInts:size withOther:[other size] withItem:other withSortSelector:@selector(compareBySize:)];
}

- (NSComparisonResult)compareByFilename:(DataFile *)other
{
	return [self compareStrings:filename withOther:[other filename] withItem:other withSortSelector:@selector(compareByFilename:)];
}

@end
