//
//  DataTab.m
//  XNJB
//

/* this class is for the data tab
 * copies files to/from NJB, deletes
 * does not support timestamp as this didn't
 * appear to work on my NJB3
 */

#import "DataTab.h"
#import "defs.h"

// these correspond to the identifiers in the NIB file
#define COLUMN_FILENAME @"Filename"
#define COLUMN_SIZE @"Size"
/*#define COLUMN_TIMESTAMP @"Timestamp" */

@implementation DataTab

- (void)onConnectAndActive
{
	[super onConnectAndActive];
	[self loadFiles];
}

- (void)awakeFromNib
{
	[super awakeFromNib];
	[browser setBaseLocation:[preferences dataTabDir]];
	
	[njbTable setAutosaveName:PREF_KEY_DATA_TAB_TABLE];
	[njbTable setAutosaveTableColumns:YES];
}

/* add downloadFileList to the NJB queue
 */
- (void)loadFiles
{
	NJBQueueItem *getFiles = [[NJBQueueItem alloc] initWithTarget:self withSelector:@selector(downloadFileList)];
	[getFiles setStatus:STATUS_DOWNLOADING_FILE_LIST];
	
	NJBQueueItem *clearSortingArrows = [[NJBQueueItem alloc] initWithTarget:self
																														 withSelector:@selector(clearSortingArrows)
																															 withObject:nil
																											withRunInMainThread:YES];
	[clearSortingArrows setDisplayStatus:NO];
	
	NJBQueueItem *updateTable = [[NJBQueueItem alloc] initWithTarget:self
																											withSelector:@selector(searchNJBTable)
																												withObject:nil
																							 withRunInMainThread:YES];
	[updateTable setDisplayStatus:NO];
	
	NSString *description = @"Getting file list";
	[self addToQueue:getFiles withSubItems:[NSArray arrayWithObjects:clearSortingArrows, updateTable, nil] withDescription:description];
	[getFiles release];
	[clearSortingArrows release];
	[updateTable release];
}

/* this is called from the queue consumer 
 * to get the files off the NJB and put them in fullItemArray
 * will run in worker thread
 */
- (NJBTransactionResult *)downloadFileList
{
	NSLog(@"Getting file");
	[fullItemArray release];
	fullItemArray = [theNJB dataFiles];
	
	NJBTransactionResult *result = [[NJBTransactionResult alloc] initWithSuccess:(fullItemArray != nil)];
	
	[fullItemArray retain];
	
	return [result autorelease];
}

/* fill the njbTable
 */
- (id)tableView:(NSTableView *)aTableView
   objectValueForTableColumn:(NSTableColumn *)aTableColumn
						row:(int)rowIndex
{	
	NSString *ident = [aTableColumn identifier];
	DataFile *dataFile = (DataFile *)[[self itemArrayDisplaying] objectAtIndex:rowIndex];
	if ([ident isEqual:COLUMN_FILENAME])
		return [dataFile filename];
	else if ([ident isEqual:COLUMN_SIZE])
		return [dataFile sizeString];
/*	else if ([ident isEqual:COLUMN_TIMESTAMP])
		return [dataFile timestampString];*/
	else
	{
	  NSLog(@"Invalid column tag in MusicTab");
		return nil;
	}
}

/* copy a file from the NJB at index index
 * in the itemArrayDisplaying
 * finds a unique filename by adding _ to the end
 */
- (void)copyFileFromNJB:(int)index
{
	DataFile *dataFile = (DataFile *)[[self itemArrayDisplaying] objectAtIndex:index];
		
	NSString *directory = [[browser directory] stringByAppendingString:@"/"];
	NSString *filename = [directory stringByAppendingString:[self replaceBadFilenameChars:[dataFile filename]]];
	
	NSFileManager *manager = [NSFileManager defaultManager];
	while ([manager fileExistsAtPath:filename])
	{
		NSLog(@"file exists: %@", filename);
		filename = [filename stringByAppendingString:@"_"];
	}
		
	NSLog(@"downloading file %@ to %@", [dataFile filename], filename);
		
	[dataFile setFullPath:filename];
		
	[self copyDataFileFromNJB:dataFile];
}

/* add the datafile dataFile to the queue
 * to be copied
 */
- (void)copyDataFileFromNJB:(DataFile *)dataFile
{
	if (![theNJB isConnected])
		return;
	NJBQueueItem *copyFile = [[NJBQueueItem alloc] initWithTarget:theNJB withSelector:@selector(downloadFile:) withObject:dataFile];
	[copyFile setStatus:STATUS_DOWNLOADING_FILE];
	NSString *description = [NSString stringWithFormat:@"Downloading file '%@'", [dataFile filename]];
	[self addToQueue:copyFile withSubItems:nil withDescription:description];
	[copyFile release];
	
	// could update browser here, but causes browser to lose selection so annoying
}

/* copy a file to the NJB
 */
- (void)copyFileToNJB:(NSString *)filename
{
	DataFile *dataFile = [DataFile dataFileFromPath:filename];
	if (dataFile == nil)
	{
		// could not open, complain
		return;
	}
	[self copyDataFileToNJB:dataFile];
}

/* add the datafile dataFile to the queue
 * to be uploaded
 */
- (void)copyDataFileToNJB:(DataFile *)dataFile
{
	if (![theNJB isConnected])
		return;
	NJBQueueItem *copyFile = [[NJBQueueItem alloc] initWithTarget:theNJB withSelector:@selector(uploadFile:) withObject:dataFile];
	[copyFile setStatus:STATUS_UPLOADING_FILE];
	
	NJBQueueItem *addToFileList = [[NJBQueueItem alloc] initWithTarget:fullItemArray withSelector:@selector(addObject:) withObject:dataFile withRunInMainThread:YES];
	[addToFileList setDisplayStatus:NO];
	
	// call searchNJBTable to pretend the search list changed to update
	NJBQueueItem *updateFileList = [[NJBQueueItem alloc] initWithTarget:self withSelector:@selector(searchNJBTable)];
	[updateFileList setRunInMainThread:YES];
	[updateFileList setDisplayStatus:NO];
	
	NSString *description = [NSString stringWithFormat:@"Uploading file '%@'", [dataFile filename]];
	[self addToQueue:copyFile withSubItems:[NSArray arrayWithObjects:addToFileList, updateFileList, nil] withDescription:description];
	
	[copyFile release];
	[addToFileList release];
	[updateFileList release];
}

/* delete the item from the NJB
 */
- (void)deleteFromNJB:(MyItem *)item
{
	DataFile *dataFile = (DataFile *)item;
		
	NJBQueueItem *deleteFile = [[NJBQueueItem alloc] initWithTarget:theNJB withSelector:@selector(deleteFile:)
																											 withObject:([NSNumber numberWithInt:[dataFile fileID]])];
	[deleteFile setStatus:STATUS_DELETING_FILE];
		
	NJBQueueItem *removeFromAllFiles = [[NJBQueueItem alloc] initWithTarget:fullItemArray withSelector:@selector(removeObject:)
																																withObject:dataFile];
	[removeFromAllFiles setRunInMainThread:YES];
	[removeFromAllFiles setDisplayStatus:NO];
		
	// call searchNJBTable to pretend the search list changed to update
	NJBQueueItem *updateFileList = [[NJBQueueItem alloc] initWithTarget:self withSelector:@selector(searchNJBTable)];
	[updateFileList setRunInMainThread:YES];
	[updateFileList setDisplayStatus:NO];
		
	NSString *description = [NSString stringWithFormat:@"Deleting file '%@'", [dataFile filename]];
	[self addToQueue:deleteFile withSubItems:[NSArray arrayWithObjects:removeFromAllFiles, updateFileList, nil] withDescription:description];
		
	[deleteFile release];
	[removeFromAllFiles release];
	[updateFileList release];
		
	NSLog(@"Deleting file id %d with filename %@", [dataFile fileID], [dataFile filename]);		
}

- (void)searchNJBTable
{
	NSString *searchString = [njbSearchField stringValue];
	// release old track list
	[truncatedItemArray release];
	
	if ([searchString length] == 0)
	{
		truncatedItemArray = nil;
		[njbTable reloadData];
		return;
	}
	
	truncatedItemArray = [fullItemArray searchFor:searchString];
	[truncatedItemArray retain];
	
	[njbTable reloadData];
	if ([njbTable selectedRow] != -1)
	{
		// update display to show new track
		[drawerController showDataFile:(DataFile *)[[self itemArrayDisplaying] objectAtIndex:[njbTable selectedRow]]];
	}
}

- (void)fileSystemBrowserFileClick:(NSString *)path
{
	[super fileSystemBrowserFileClick:path];
	DataFile *dataFile = [DataFile dataFileFromPath:path];
	[drawerController showDataFile:dataFile];
}

- (void)fileSystemBrowserDirectoryClick:(NSString *)path
{
	[super fileSystemBrowserDirectoryClick:path];
	[drawerController disableAll];
}

- (void)onFirstResponderChange:(NSResponder *)aResponder
{
	[super onFirstResponderChange:(NSResponder *)aResponder];
	if (aResponder == njbTable)
	{
		// update display to show new track
		if ([njbTable selectedRow] > -1)
		{
			[drawerController showDataFile:(DataFile *)[[self itemArrayDisplaying] objectAtIndex:[njbTable selectedRow]]];
		}
	}
	// todo: is there a better way of finding out if it's the search field?
	else if ([aResponder class] == [NSSearchField class])
	{
		[drawerController disableAll];
	}
}

- (void)tableViewSelectionDidChange:(NSNotification *)aNotification
{
	[super tableViewSelectionDidChange:aNotification];
	
	int newRow = [njbTable selectedRow];
	if (newRow == -1)
		return;
	
	// update display to show new file
	[drawerController showDataFile:(DataFile *)[[self itemArrayDisplaying] objectAtIndex:newRow]];
}

- (void)activate
{
	[super activate];
	if (activeObject == OBJECT_NJB_TABLE)
	{
		if ([njbTable selectedRow] != -1)
		{
			[drawerController showDataFile:(DataFile *)[[self itemArrayDisplaying] objectAtIndex:[njbTable selectedRow]]];
		}
	}
	else if (activeObject == OBJECT_FILE_BROWSER)
	{
		if (![browser isDirectory])
		{
			DataFile *dataFile = [DataFile dataFileFromPath:[browser path]];
			if (dataFile != nil)
				[drawerController showDataFile:dataFile];
		}
	}
}

- (void)tableView:(NSTableView *)tableView didClickTableColumn:(NSTableColumn *)tableColumn
{	
	// disable and clear the drawer
	[drawerController clearAll];
	[drawerController disableAll];
	
	[super tableView:tableView didClickTableColumn:tableColumn];
}

- (SEL)sortSelectorForColumn:(NSString *)columnID
{
	if ([columnID isEqual:COLUMN_FILENAME])
		return [DataFile compareByFilenameSelector];
	else if ([columnID isEqual:COLUMN_SIZE])
		return [DataFile compareBySizeSelector];
	else
  {	
		NSLog(@"Invalid column %@ in sortSelectorForColumn!", columnID);
		return nil;
	}
}

- (void)applicationTerminating:(NSNotification *)note
{
	[preferences setLastUsedDataTabDir:[self browserDirectory]];
	[super applicationTerminating:note];
}

@end
