//
//  Preferences.h
//  XNJB
//
//  Created by Richard Low on Tue Aug 31 2004.
//

#import <Foundation/Foundation.h>
@class MusicTab;
@class DataTab;
@class MainController;
@class DrawerController;

@interface Preferences : NSObject {
  NSUserDefaults *defaults;
}

- (void)registerDefaults;
- (BOOL)connectOnStartup;
- (void)setConnectOnStartup:(BOOL)connectOnStartup;
- (int)startupTab;
- (void)setStartupTab:(int)startupTab;
- (NSString *)musicTabDir;
- (void)setMusicTabDir:(NSString *)musicTabDir;
- (NSString *)dataTabDir;
- (void)setDataTabDir:(NSString *)dataTabDir;
- (void)setMusicTabDirLastUsed:(BOOL)musicTabDirLastUsed;
- (void)setDataTabDirLastUsed:(BOOL)dataTabDirLastUsed;
- (BOOL)musicTabDirLastUsed;
- (BOOL)dataTabDirLastUsed;
- (void)setStartupTabLastUsed:(BOOL)startupTabLastUsed;
- (BOOL)startupTabLastUsed;
- (NSString *)filenameFormat;
- (void)setFilenameFormat:(NSString *)filenameFormat;
- (BOOL)showDrawer;
- (void)setShowDrawer:(BOOL)newShowDrawer;
- (void)setLastUsedMusicTabDir:(NSString *)musicTabDir;
- (void)setLastUsedDataTabDir:(NSString *)dataTabDir;
- (void)setLastUsedTab:(int)tab;
- (void)setDrawerContentSize:(NSSize)size;
- (NSSize)drawerContentSize;
- (NSRectEdge)drawerEdge;
- (void)setDrawerEdge:(NSRectEdge)drawerEdge;
- (BOOL)writeTagAfterCopy;
- (void)setWriteTagAfterCopy:(BOOL)writeTagAfterCopy;
@end
