//
//  Preferences.m
//  XNJB
//
//  Created by Richard Low on Tue Aug 31 2004.
//

/* Wrapper for preferences in NSUserDefaults
 * See keys/default objects in defs.h
 */

#import "Preferences.h"
#import "defs.h"

@implementation Preferences

// init/dealloc methods

- (id)init
{
	if (self = [super init])
	{
		defaults = [NSUserDefaults standardUserDefaults];
		[self registerDefaults];
	}
	return self;
}

// accessor methods

- (BOOL)connectOnStartup
{
	return [defaults boolForKey:PREF_KEY_CONNECT_ON_STARTUP];
}

- (void)setConnectOnStartup:(BOOL)connectOnStartup
{
	[defaults setObject:[NSNumber numberWithBool:connectOnStartup] forKey:PREF_KEY_CONNECT_ON_STARTUP];
}

- (int)startupTab
{
	int tab = [defaults integerForKey:PREF_KEY_STARTUP_TAB];
	if (tab >= 0)
		return tab;
	else
		return 0;
}

- (void)setStartupTab:(int)startupTab
{
	[defaults setObject:[NSNumber numberWithInt:startupTab] forKey:PREF_KEY_STARTUP_TAB];
}

- (BOOL)startupTabLastUsed
{
	return [defaults boolForKey:PREF_KEY_STARTUP_TAB_LAST_USED];
}

- (void)setStartupTabLastUsed:(BOOL)startupTabLastUsed
{
	[defaults setObject:[NSNumber numberWithBool:startupTabLastUsed] forKey:PREF_KEY_STARTUP_TAB_LAST_USED];
}

- (NSString *)musicTabDir
{
	return [defaults objectForKey:PREF_KEY_MUSIC_TAB_DIR];
}

- (void)setMusicTabDir:(NSString *)musicTabDir
{
	[defaults setObject:musicTabDir forKey:PREF_KEY_MUSIC_TAB_DIR];
}

- (NSString *)dataTabDir
{
	return [defaults objectForKey:PREF_KEY_DATA_TAB_DIR];
}

- (void)setDataTabDir:(NSString *)dataTabDir
{
	[defaults setObject:dataTabDir forKey:PREF_KEY_DATA_TAB_DIR];
}

- (BOOL)musicTabDirLastUsed
{
	return [defaults boolForKey:PREF_KEY_MUSIC_TAB_DIR_LAST_USED];
}

- (void)setMusicTabDirLastUsed:(BOOL)musicTabDirLastUsed
{
	[defaults setObject:[NSNumber numberWithBool:musicTabDirLastUsed] forKey:PREF_KEY_MUSIC_TAB_DIR_LAST_USED];
}

- (BOOL)dataTabDirLastUsed
{
	return [defaults boolForKey:PREF_KEY_DATA_TAB_DIR_LAST_USED];
}

- (void)setDataTabDirLastUsed:(BOOL)dataTabDirLastUsed
{
	[defaults setObject:[NSNumber numberWithBool:dataTabDirLastUsed] forKey:PREF_KEY_DATA_TAB_DIR_LAST_USED];
}

- (NSString *)filenameFormat
{
	return [defaults objectForKey:PREF_KEY_FILENAME_FORMAT];
}

- (void)setFilenameFormat:(NSString *)filenameFormat
{
	[defaults setObject:filenameFormat forKey:PREF_KEY_FILENAME_FORMAT];
}

- (BOOL)showDrawer
{
	return [defaults boolForKey:PREF_KEY_SHOW_DRAWER];
}

- (void)setShowDrawer:(BOOL)newShowDrawer
{
	[defaults setObject:[NSNumber numberWithBool:newShowDrawer] forKey:PREF_KEY_SHOW_DRAWER];
}

- (void)setLastUsedMusicTabDir:(NSString *)musicTabDir
{
	if ([self musicTabDirLastUsed])
		[self setMusicTabDir:musicTabDir];
}

- (void)setLastUsedDataTabDir:(NSString *)dataTabDir
{
	if ([self dataTabDirLastUsed])
		[self setDataTabDir:dataTabDir];
}

- (void)setLastUsedTab:(int)tab
{
	if ([self startupTabLastUsed])
		[self setStartupTab:tab];
}

- (void)setDrawerContentSize:(NSSize)size
{
	[defaults setObject:[NSNumber numberWithFloat:size.height] forKey:PREF_KEY_DRAWER_CONTENT_SIZE_HEIGHT];
	[defaults setObject:[NSNumber numberWithFloat:size.width] forKey:PREF_KEY_DRAWER_CONTENT_SIZE_WIDTH];
}

- (NSSize)drawerContentSize
{
	NSSize size;
	size.height = [defaults floatForKey:PREF_KEY_DRAWER_CONTENT_SIZE_HEIGHT];
	size.width = [defaults floatForKey:PREF_KEY_DRAWER_CONTENT_SIZE_WIDTH];
	return size;
}

- (BOOL)writeTagAfterCopy
{
	return [defaults boolForKey:PREF_KEY_WRITE_TAG_AFTER_COPY];
}

- (void)setWriteTagAfterCopy:(BOOL)writeTagAfterCopy
{
	[defaults setObject:[NSNumber numberWithBool:writeTagAfterCopy] forKey:PREF_KEY_WRITE_TAG_AFTER_COPY];
}

- (NSRectEdge)drawerEdge
{
	return [defaults integerForKey:PREF_KEY_DRAWER_EDGE];
}

- (void)setDrawerEdge:(NSRectEdge)drawerEdge
{
	[defaults setObject:[NSNumber numberWithInt:drawerEdge] forKey:PREF_KEY_DRAWER_EDGE];
}

/**********************/

- (void)registerDefaults
{
	NSMutableDictionary *defaultValues = [NSMutableDictionary dictionary];
	
	// CONNECT_ON_STARTUP
	[defaultValues setObject:DEFAULT_CONNECT_ON_STARTUP forKey:PREF_KEY_CONNECT_ON_STARTUP];
	// STARTUP_TAB
	[defaultValues setObject:DEFAULT_STARTUP_TAB forKey:PREF_KEY_STARTUP_TAB];
	// STARTUP_TAB_LAST_USED
	[defaultValues setObject:DEFAULT_STARTUP_TAB_LAST_USED forKey:PREF_KEY_STARTUP_TAB_LAST_USED];
	// MUSIC_TAB_DIR
	[defaultValues setObject:DEFAULT_MUSIC_TAB_DIR forKey:PREF_KEY_MUSIC_TAB_DIR];
	// MUSIC_TAB_DIR_LAST_USED
	[defaultValues setObject:DEFAULT_MUSIC_TAB_DIR_LAST_USED forKey:PREF_KEY_MUSIC_TAB_DIR_LAST_USED];
	// DATA_TAB_DIR
	[defaultValues setObject:DEFAULT_DATA_TAB_DIR forKey:PREF_KEY_DATA_TAB_DIR];
	// DATA_TAB_DIR_LAST_USED
	[defaultValues setObject:DEFAULT_DATA_TAB_DIR_LAST_USED forKey:PREF_KEY_DATA_TAB_DIR_LAST_USED];
	// FILENAME_FORMAT
	[defaultValues setObject:DEFAULT_FILENAME_FORMAT forKey:PREF_KEY_FILENAME_FORMAT];
	// SHOW_DRAWER
	[defaultValues setObject:DEFAULT_SHOW_DRAWER forKey:PREF_KEY_SHOW_DRAWER];
	// DRAWER_CONTENT_SIZE_HEIGHT
	[defaultValues setObject:DEFAULT_DRAWER_CONTENT_SIZE_HEIGHT forKey:PREF_KEY_DRAWER_CONTENT_SIZE_HEIGHT];
	// DRAWER_CONTENT_SIZE_WIDTH
	[defaultValues setObject:DEFAULT_DRAWER_CONTENT_SIZE_WIDTH forKey:PREF_KEY_DRAWER_CONTENT_SIZE_WIDTH];
	// WRITE_TAG_AFTER_COPY
	[defaultValues setObject:DEFAULT_WRITE_TAG_AFTER_COPY forKey:PREF_KEY_WRITE_TAG_AFTER_COPY];
	// DRAWER_EDGE
	[defaultValues setObject:DEFAULT_DRAWER_EDGE forKey:PREF_KEY_DRAWER_EDGE];
	
	[defaults registerDefaults:defaultValues];
}

@end
