//
//  MyMutableArray.h
//  XNJB
//
//  Created by Richard Low on Fri Aug 20 2004.
//

#import <Foundation/Foundation.h>
#import "MyItem.h"

typedef enum _sortDirections {SORT_ASCENDING = 0, SORT_DESCENDING = 1} sortDirections;

@interface MyMutableArray : NSObject {
  NSMutableArray *objects;
	SEL mainSortSelector;
	SEL secondarySortSelector;
}
- (void)addObject:(MyItem *)item;
- (void)removeObjectAtIndex:(unsigned)index;
- (void)removeObject:(MyItem *)item;
- (MyItem *)objectAtIndex:(unsigned)index;
- (void)replaceObjectAtIndex:(unsigned)index withObject:(MyItem *)modifiedItem;
- (void)replaceObject:(MyItem *)replace withObject:(MyItem *)new;
- (unsigned)count;
- (unsigned)indexOfObject:(MyItem *)object;
- (MyMutableArray *)searchFor:(NSString *)search;
- (void)sortUsingSelector:(SEL)newSortSelector andSelector:(SEL)oldSortSelector inDirection:(sortDirections)direction;
- (void)sortUsingSelector:(SEL)newSortSelector inDirection:(sortDirections)direction;
- (id)initWithMyMutableArray:(MyMutableArray *)array;
- (NSEnumerator *)objectEnumerator;
- (void)exchangeObjectAtIndex:(unsigned)idx1 withObjectAtIndex:(unsigned)idx2;
@end
