#include <libnjb.h>
#include <getopt.h>

int main (int argc, char **argv)
{
	njb_t njbs[NJB_MAX_DEVICES];
	njb_t *njb;
	njbid_t *njbid = NULL;
	int i, n, opt, debug;
	extern char *optarg;

	debug= 0;
	while ( (opt= getopt(argc, argv, "D:")) != -1 ) {
		switch (opt) {
		case 'D':
			debug= atoi(optarg);
			break;
		default:
			fprintf(stderr, "usage: handshake [ -D debuglvl ]\n");
			return 1;
		}
	}

	if ( debug ) NJB_Set_Debug(debug);

	if ( NJB_Discover(njbs, 0, &n) == -1 ) {
		njb_error_dump(stderr);
	}

	if ( n == 0 ) {
		fprintf(stderr, "No NJB devices found\n");
		return 1;
	}

	printf("Found %u devices.\n", n);
	
	for (i = 0; i < n; i++) {
	  njb_keyval_t *key;
	  njb = &njbs[i];
	  printf("Device %u: ", i+1);
	  switch (njb->device_type)
	    {
	    case NJB_DEVICE_NJB1:
	      printf("\n    Jukebox type: Nomad Jukebox 1\n");
	      break;
	    case NJB_DEVICE_NJB2:
	      printf("\n    Jukebox type: Nomad Jukebox 2\n");
	      break;
	    case NJB_DEVICE_NJB3:
	      printf("\n    Jukebox type: Nomad Jukebox 3\n");
	      break;
	    case NJB_DEVICE_NJBZEN:
	      printf("\n    Jukebox type: Nomad Jukebox Zen\n");
	      break;
	    case NJB_DEVICE_NJBZEN2:
	      printf("\n    Jukebox type: Nomad Jukebox Zen USB 2.0\n");
	      break;
	    case NJB_DEVICE_NJBZENNX:
	      printf("\n    Jukebox type: Nomad Jukebox Zen NX\n");
	      break;
	    case NJB_DEVICE_NJBZENXTRA:
	      printf("\n    Jukebox type: Nomad Jukebox Zen Xtra\n");
	      break;
	    case NJB_DEVICE_DELLDJ:
	      printf("\n    Jukebox type: Dell Digital Jukebox\n");
	      break;
	    case NJB_DEVICE_NJBZENTOUCH:
	      printf("\n    Jukebox type: Creative Jukebox Zen Touch\n");
	      break;
	    default:
	      printf("\n    Unknown jukebox type.\n");
	    }

	  njb= &njbs[i];

	  if ( NJB_Open(njb) == -1 ) {
	    njb_error_dump(stderr);
	    return 1;
	  }

	  if ((njbid = NJB_Ping(njb)) == NULL) {
	    njb_error_dump(stderr);
	    return 1;
	  }

	  printf("    Jukebox SDMI ID: %s\n", njb->idstring);

	  if (njb->device_type == NJB_DEVICE_NJB1) {
	    printf("    Firmware: %u.%u\n", njb->fwMajor, 
		   njb->fwMinor);
	  }
	  else {
	    printf("    Firmware: %u.%u.%u\n", njbid->fwMajor, 
		   njbid->fwMinor, njbid->fwRel);
	    printf("    Hardware: %u.%u.%u\n", njbid->hwMajor, 
		   njbid->hwMinor, njbid->hwRel);
	  }
	  
	  printf("    Product name: %s\n", njbid->productName);
	  
	  /* This doesn't exist (apparently) on NJB3 */
	  if (njb->device_type == NJB_DEVICE_NJB1) {
	    printf("    Power connected: %s\n", njbid->power ? "yes":"no");
	  }

	  key = NJB_Get_Keys(njb);
	  while (key != NULL) {
	    printf("    Device key: %s = %08X, %08X\n", key->key, key->value1, key->value2);
	    key = key->next;
	  }
	  
	  
	  free(njbid);
	  
	  NJB_Close(njb);

	}

	return 0;
}

