//
//  MyMutableArray.m
//  XNJB
//
//  Created by Richard Low on Fri Aug 20 2004.
//

/* implements a sortable NSMutableArray
 * using the items (MyItem) to sort themselves 
 * and allows string searching
 */

#import "MyMutableArray.h"

sortDirections sortDirection = SORT_ASCENDING;
SEL sortSelector = nil;

@implementation MyMutableArray

// init/dealloc methods

- (id)init
{
	if (self = [super init])
	{
		objects = [[NSMutableArray alloc] init];
	}
	return self;
}

- (id)initWithMyMutableArray:(MyMutableArray *)array
{
	if (self = [super init])
	{
		objects = [[NSMutableArray alloc] init];
		[objects setArray:array->objects];
	}
	return self;
}

- (void)dealloc
{
	[objects release];
	[super dealloc];
}

// accessor methods

- (void)addObject:(MyItem *)object
{
	[objects addObject:object];
}

- (void)removeObjectAtIndex:(unsigned)index
{
	[objects removeObjectAtIndex:index];
}

- (void)removeObject:(MyItem *)object
{
	[objects removeObject:object];
}

- (MyItem *)objectAtIndex:(unsigned)index
{
	return [objects objectAtIndex:index];
}

- (void)replaceObjectAtIndex:(unsigned)index withObject:(MyItem *)modifiedObject
{
	[objects replaceObjectAtIndex:index withObject:modifiedObject];
}

- (unsigned int)count
{
	return [objects count];
}

- (void)replaceObject:(MyItem *)replace withObject:(MyItem *)new
{
	int index = [objects indexOfObject:replace];
	if (index == NSNotFound)
	{
		NSLog(@"replaceObject: object to replace not found!");
		return;
	}
	[objects replaceObjectAtIndex:index withObject:new];
}

- (NSEnumerator *)objectEnumerator
{
	return [objects objectEnumerator];
}

- (unsigned)indexOfObject:(MyItem *)object
{
	return [objects indexOfObject:object];
}

- (void)exchangeObjectAtIndex:(unsigned)idx1 withObjectAtIndex:(unsigned)idx2
{
	[objects exchangeObjectAtIndex:idx1 withObjectAtIndex:idx2];
}

- (NSString *)description
{
	return [objects description];
}

- (BOOL)isEqual:(MyItem *)obj
{
	return [objects isEqual:obj];
}

/**********************/

- (MyMutableArray *)searchFor:(NSString *)search
{
	MyMutableArray *truncatedItemArray = [[MyMutableArray alloc] init];
	int i = -1;
	for (i = 0; i < [self count]; i++)
	{
		if ([[self objectAtIndex:i] matchesString:search])
			[truncatedItemArray addObject:[self objectAtIndex:i]];
	}
	return [truncatedItemArray autorelease];
}

- (void)sortUsingSelector:(SEL)newSortSelector andSelector:(SEL)oldSortSelector inDirection:(sortDirections)direction
{
	// sets the global variables so my elements can read them
	sortDirection = direction;
	sortSelector = oldSortSelector;
	[objects sortUsingSelector:newSortSelector];
}

- (void)sortUsingSelector:(SEL)newSortSelector inDirection:(sortDirections)direction
{
	[self sortUsingSelector:newSortSelector andSelector:nil inDirection:direction];
}

@end
