//
//  DataFileList.m
//  XNJB
//
//  Created by Richard Low on Sat Aug 21 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

#import "DataFileList.h"
#import "DataFile.h"

@implementation DataFileList

- (void)sortByFilename
{
	[objects sortUsingSelector:[DataFile compareByFilenameSelector]];
}

- (void)sortByTimestamp
{
	[objects sortUsingSelector:[DataFile compareByTimestampSelector]];
}

- (void)sortBySize
{
	[objects sortUsingSelector:[DataFile compareBySizeSelector]];
}

- (DataFileList *)searchFor:(NSString *)search
{
	DataFileList *truncatedFileList = [[DataFileList alloc] init];
	int i = -1;
	for (i = 0; i < [self count]; i++)
	{
		if ([[self objectAtIndex:i] matchesString:search])
			[truncatedFileList addObject:[self objectAtIndex:i]];
	}
	[truncatedFileList autorelease];
	return truncatedFileList;
}

@end
