%define name    libnjb
%define	version	1.3
# Final releases: "1" = release number of final release, version 1
# CVS releases  : "0.yyyymmdd" = prerelease from CVS at date
#                 "0.yyyymmdd.rh9" = For Redhat 9
#                 "0.yyyymmdd.FC1" = For fedora core 1
# Distributions : "1.rh9" = version 1 for redhat 9, release 1
#                 "1.FC1" = version 1 for fedora core 1, release 1
%define	release	0.20041130.FC3
%define	prefix	/usr

Name:		%{name}
Version:	%{version}
Release:	%{release}
Summary:	A software library for talking to the Creative Nomad Jukebox
URL:		http://sourceforge.net/projects/libnjb
Packager:	Linus Walleij <triad@df.lth.se>
Group:		System Environment/Libraries
Source:		%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-buildroot
Copyright:	BSD
Prefix:         %{_prefix}
Docdir:		%{prefix}/doc
Requires:       libusb
BuildRequires:	libusb-devel

%description
This package provides a software library for communicating with the
Creative Nomad Jukebox line of MP3 players.

%package samples
Summary:        Sample programs for talking to the Creative Nomad Jukebox
Group:          System Environment/Libraries
Requires:       %{name} = %{version}

%description samples
This package provides sample programs for communicating with the
Creative Nomad Jukebox line of MP3 players.

%prep
%setup -q

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefix}
make lib samples

%install
if [ -d $RPM_BUILD_ROOT ]; then rm -r $RPM_BUILD_ROOT; fi
make prefix=$RPM_BUILD_ROOT%{prefix} install install-samples
# install hotplug scripts so they are up to date
mkdir -p $RPM_BUILD_ROOT/etc/hotplug/usb
install -m 755 nomadjukebox $RPM_BUILD_ROOT/etc/hotplug/usb
install -m 644 nomad.usermap $RPM_BUILD_ROOT/etc/hotplug/usb

%clean
if [ -d $RPM_BUILD_ROOT ]; then rm -r $RPM_BUILD_ROOT; fi

%post
/sbin/ldconfig
# This is much because RedHat use an old hotplug version that
# doesn't recognize the personalized usermap properly.
function inmap {
    while read LINE; do
	if [ "x${LINE}" != "x" ]; then
	    firstword=`echo ${LINE} | awk '{ print $1 }'`
	    if [ ${firstword} != "#" ]; then
		script=${firstword}
		manid=`echo ${LINE} | awk '{ print $3 }'`
		productid=`echo ${LINE} | awk '{ print $4 }'`
		if [ "x${script}" = "x$2" ]; then 
		    if [ "x${manid}" = "x$3" ]; then 
			if [ "x${productid}" = "x$4" ]; then
			    echo "yes"
			    return 0
			fi
		    fi
		fi
	    fi
	fi
    done < $1
    echo "no"
    return 0
}
function patchusermap {
    comment=""
    while read LINE; do
	if [ "x$LINE" != "x" ]; then
	    firstword=`echo ${LINE} | awk '{ print $1 }'`
	    if [ ${firstword} = "#" ]; then
		comment=${LINE}
	    else
		script=${firstword}
		manid=`echo ${LINE} | awk '{ print $3 }'`
		productid=`echo ${LINE} | awk '{ print $4 }'`
		if [ "x${manid}" != "x" ]; then
		    echo "Checking for product ${productid} in $2..."
		    if [ `inmap $2 ${script} ${manid} ${productid}` = "no" ]; then
			echo "Not present, adding to hotplug map."
			echo ${LINE} >> $2
			comment=""
		    else
			echo "Already installed."
		    fi
		fi
	    fi
	fi
    done < $1
}
echo "Checking hotplugging CVS version..."
echo "/etc/hotplug/usb/*.usermap support was added in august 2002"
EDITMAP="yes"
CVSTAG=`grep '\$Id:' /etc/hotplug/usb.agent`
if [ "x${CVSTAG}" != "x" ]; then
    DATE=`echo ${CVSTAG} | awk '{ print $5 }'`
    echo "Hotplug version seems to be from ${DATE}"
    YEAR=`echo ${DATE} | awk 'BEGIN { FS="/"} {print $1; }'`
    MONTH=`echo ${DATE} | awk 'BEGIN { FS="/"} {print $2; }'`
    DAY=`echo ${DATE} | awk 'BEGIN { FS="/"} {print $3; }'`
    if [ "${YEAR}" -gt "2002" ]; then
	EDITMAP="no"
    else
	if [ "${YEAR}" -eq "2002" ]; then
	    if [ "${MONTH}" -ge "08" ]; then
		EDITMAP="no"
	    fi
	fi
    fi
fi
if [ "x${EDITMAP}" = "xyes" ]; then
    echo "We need to edit the ${HOTPLUGPATH}/usb.usermap if it exists..."
    patchusermap /etc/hotplug/usb/nomad.usermap /etc/hotplug/usb.usermap
else
    echo "No need to edit the ${HOTPLUGPATH}/usb.usermap file."
fi

%postun
/sbin/ldconfig
# Remove entries from the usermap? What if someone has installed
# another program or from source? No way. See if the "nomadjukebox"
# script is still there, else remove the entries.
if test -f /etc/hotplug/usb/nomadjukebox
then
    # Nothing
    echo "Nothing to remove from usb.usermap."
else
    echo "Checking hotplugging CVS version..."
    echo "/etc/hotplug/usb/*.usermap support was added in august 2002"
    EDITMAP="yes"
    CVSTAG=`grep '\$Id:' /etc/hotplug/usb.agent`
    if [ "x${CVSTAG}" != "x" ]; then
    	DATE=`echo ${CVSTAG} | awk '{ print $5 }'`
    	echo "Hotplug version seems to be from ${DATE}"
    	YEAR=`echo ${DATE} | awk 'BEGIN { FS="/"} {print $1; }'`
    	MONTH=`echo ${DATE} | awk 'BEGIN { FS="/"} {print $2; }'`
    	DAY=`echo ${DATE} | awk 'BEGIN { FS="/"} {print $3; }'`
    	if [ "${YEAR}" -gt "2002" ]; then
		EDITMAP="no"
	else
		if [ "${YEAR}" -eq "2002" ]; then
	    		if [ "${MONTH}" -ge "08" ]; then
				EDITMAP="no"
	    		fi
		fi
    	fi
    fi
    if [ "x${EDITMAP}" = "xyes" ]; then
	# Remove any hotplug refs this hairy way
    	grep ^'[^n][^o][^m][^a][^d][^j][^u][^k][^e][^b][^o][^x]' /etc/hotplug/usb.usermap > /tmp/gnomad2.tmp
    	mv /tmp/gnomad2.tmp /etc/hotplug/usb.usermap
    	echo "Removed jukebox entries from usb.usermap."
    else
	echo "No need to remove any usb.usermap entries."
    fi
fi

%files
%defattr(-, root, root)
%{prefix}/lib/*.so
%{prefix}/lib/*.a
%{prefix}/lib/*.la
%{prefix}/include/*.h
%dir %{prefix}/lib/pkgconfig
%{prefix}/lib/pkgconfig/*.pc
%dir /etc/hotplug/usb
%config(noreplace) /etc/hotplug/usb/*
%doc AUTHORS CHANGES FAQ INSTALL LICENSE HACKING

%files samples
%defattr(-, root, root)
%{prefix}/bin/*
%doc AUTHORS CHANGES FAQ INSTALL LICENSE HACKING

%changelog
* Tue Nov 30 2004 Linus Walleij <triad@df.lth.se> 1.3-0.20041130
- A CVS snapshot for the new API and all.
* Wed Sep 29 2004 Linus Walleij <triad@df.lth.se> 1.2-0.20040929
- A CVS snapshot, much needed, which also works
* Fri Sep 24 2004 Linus Walleij <triad@df.lth.se> 1.2-0.20040924
- A CVS snapshot, much needed.
* Tue May 25 2004 Linus Walleij <triad@df.lth.se> 1.1-1
- Added hook to redistribute pkgconfig module
* Wed Apr 25 2004 Linus Walleij <triad@df.lth.se> 1.1-1
- Final 1.1 release!
* Wed Apr 21 2004 Linus Walleij <triad@df.lth.se> 1.0.2-0.20040421
- A new CVS snapshot.
* Fri Apr 9 2004 Linus Walleij <triad@df.lth.se> 1.0.2-0.20040409
- A new CVS snapshot.
* Sun Feb 22 2004 Linus Walleij <triad@df.lth.se> 1.0.2-0.20040222
- A new CVS snapshot. Adressing several bugs.
* Fri Jan 9 2004 Linus Walleij <triad@df.lth.se> 1.0.1-0.20040109
- A new CVS release adressing bugs, better numbering scheme
* Tue Dec 9 2003 Linus Walleij <triad@df.lth.se> 1.0.1-1
- Addressed some issues in 1.0
* Tue Dec 9 2003 Linus Walleij <triad@df.lth.se> 1.0-2
- Second package for samples
* Sat Dec 6 2003 Linus Walleij <triad@df.lth.se> 1.0-1
- Final 1.0 release
* Sun Aug 17 2003 Linus Walleij <triad@df.lth.se> 1.1.0b-6
- Seventh RPM
* Sun Aug 17 2003 Linus Walleij <triad@df.lth.se> 1.1.0b-5
- Sixth RPM
* Thu Jul 31 2003 Linus Walleij <triad@df.lth.se> 1.1.0b-4
- Fifth RPM
* Wed Jun 11 2003 Linus Walleij <triad@df.lth.se> 1.1.0b-3
- Fourth RPM.
* Mon Apr 21 2003 Linus Walleij <triad@df.lth.se> 1.1.0b-2
- Third RPM, big improvements in hotplug installation.
* Sun Mar 30 2003 Linus Walleij <triad@df.lth.se> 1.1.0b
- Second CVS RPM
* Thu Dec 26 2002 Dwight Engen <dengen40@yahoo.com> 0.9.1
- First RPM'ed
