#include <libnjb.h>
#include <getopt.h>

int main(int argc, char **argv)
{
	njb_t njbs[NJB_MAX_DEVICES], *njb;
	extern char *optarg;
	int opt;
	int i, n, debug;
	njb_eax_t *eax;

	debug = 0;
	while ((opt = getopt(argc, argv, "D:")) != -1) {
		switch (opt) {
		case 'D':
			debug = atoi(optarg);
			break;
		default:
			fprintf(stderr, "usage: dumpeax [ -D debuglvl ]\n");
			return 1;
		}
	}

	if (debug)
		NJB_Set_Debug(debug);

	if (NJB_Discover(njbs, 0, &n) == -1) {
	        fprintf(stderr, "could not locate any jukeboxes\n");
		exit(1);
	}

	if (n == 0) {
		fprintf(stderr, "no NJB devices found\n");
		return 0;
	}

	njb = njbs;

	if (NJB_Open(njb) == -1) {
		NJB_Error_Dump(njb, stderr);
		return 1;
	}

	if (NJB_Capture(njb) == -1) {
		NJB_Error_Dump(njb, stderr);
		return 1;
	}

	NJB_Reset_Get_EAX_Type (njb);
	
	while ((eax = NJB_Get_EAX_Type (njb)) != NULL) {
	  printf("------------------------------------------\n");
	  printf("Effect number: %04X\n", eax->number);
	  printf("Effect name: %s\n", eax->name);
	  printf("Effect group %d\n", eax->group);
	  if (eax->exclusive != 0x00) {
	    printf("Effect is exclusive\n");
	  }
	  if (eax->selectable != 0x00) {
	    printf("Effect has selectable patches:\n");
	    printf("    Current selection: %d\n", eax->current_selectionvalue);
	    for(i = 0; i < eax->max_selectionvalue - eax->min_selectionvalue + 1; i++) {
	      printf("    %d. %s\n", eax->min_selectionvalue+i, eax->selection_names[i]);
	    }
	  }
	  if (eax->scaleable != 0x00) {
	    printf("Effect is scaleable:\n");
	    printf("    Current value: %d\n", eax->current_scalevalue);
	    printf("    Min value: %d\n", eax->min_scalevalue);
	    printf("    Max value %d\n", eax->max_scalevalue);
	  }	  
	  NJB_Destroy_EAX_Type (eax);
	}

	/* Dump any pending errors */
	NJB_Error_Dump(njb, stderr);

	NJB_Release(njb);

	NJB_Close(njb);
	return 0;
}
