#include <libnjb.h>
#include <getopt.h>

static void usage (void)
{
  fprintf(stderr, "usage: setpbm [ -D debuglvl ] <path>\n");
  exit(1);
}

int main(int argc, char **argv)
{
  njb_t njbs[NJB_MAX_DEVICES], *njb;
  int n, opt, debug;
  extern int optind;
  extern char *optarg;
  char *path;
  
  debug = 0;
  while ( (opt = getopt(argc, argv, "D:")) != -1 ) {
    switch (opt) {
    case 'D':
      debug= atoi(optarg);
      break;
    default:
      usage();
    }
  }

  argc-= optind;
  argv+= optind;
  
  if ( argc != 1 ) usage();
  
  if ( debug ) NJB_Set_Debug(debug);

  path= argv[0];
  
  printf("Uploading image:\n");
  printf("Filename:     %s\n", path);

  if (NJB_Discover(njbs, 0, &n) == -1) {
    fprintf(stderr, "could not locate any jukeboxes\n");
    return 1;
  }
  
  if ( n == 0 ) {
    fprintf(stderr, "no NJB devices found\n");
    return 0;
  } 
  
  njb = njbs;

  if ( NJB_Open(njb) == -1 ) {
    NJB_Error_Dump(njb,stderr);
    return 1;
  }

  NJB_Capture(njb);
  
  if ( NJB_Set_Bitmap(njb, path) == -1 ) {
    NJB_Error_Dump(njb,stderr);
  }
  
  NJB_Release(njb);
  
  NJB_Close (njb);

  return 0;
}
