#ifndef __NJBUSB__H
#define __NJBUSB__H

#ifndef HAVE_LIBUSB
#define DEFAULT_DEV	"/dev/usb0"
#endif

#define NJB1_VENDOR_ID		0x0471
#define NJB1_PRODUCT_ID		0x0222

#define NJB2_VENDOR_ID		0x041e
#define NJB2_PRODUCT_ID		0x4100

#define NJB3_VENDOR_ID		0x041e
#define NJB3_PRODUCT_ID		0x4101

#define NJBZEN_VENDOR_ID	0x041e
#define NJBZEN_PRODUCT_ID	0x4108

#define NJBZEN2_VENDOR_ID	0x041e
#define NJBZEN2_PRODUCT_ID	0x410B

#define NJBZENNX_VENDOR_ID	0x041e
#define NJBZENNX_PRODUCT_ID	0x4109

#define NJBZENXTRA_VENDOR_ID	0x041e
#define NJBZENXTRA_PRODUCT_ID	0x4110

#define DELLDJ_VENDOR_ID        0x041e
#define DELLDJ_PRODUCT_ID       0x4111

#define NJBZENTOUCH_VENDOR_ID	0x041e
#define NJBZENTOUCH_PRODUCT_ID	0x411b

#define NJBZENMICRO_VENDOR_ID	0x041e
#define NJBZENMICRO_PRODUCT_ID	0x411e

#define DELLDJ2_VENDOR_ID       0x041e
#define DELLDJ2_PRODUCT_ID      0x4126

/*
 * Macros to detect certain features of the device
 * great for code readability.
 */

#define USB20_DEVICE(t) \
        (t == NJB_DEVICE_NJB2 || \
         t == NJB_DEVICE_NJBZEN2 || \
         t == NJB_DEVICE_NJBZENNX || \
         t == NJB_DEVICE_NJBZENXTRA || \
         t == NJB_DEVICE_DELLDJ || \
         t == NJB_DEVICE_NJBZENTOUCH || \
	 t == NJB_DEVICE_NJBZENMICRO || \
         t == NJB_DEVICE_DELLDJ2 )

#define PROTOCOL3_DEVICE(t) \
        (t == NJB_DEVICE_NJB2 || \
	 t == NJB_DEVICE_NJB3 || \
         t == NJB_DEVICE_NJBZEN || \
         t == NJB_DEVICE_NJBZEN2 || \
         t == NJB_DEVICE_NJBZENNX || \
         t == NJB_DEVICE_NJBZENXTRA || \
         t == NJB_DEVICE_DELLDJ || \
         t == NJB_DEVICE_NJBZENTOUCH || \
         t == NJB_DEVICE_NJBZENMICRO || \
         t == NJB_DEVICE_DELLDJ2 )

#endif

