//
//  NJB.h
//  XNJB
//
//  Created by Richard Low on Wed Jul 21 2004.
//

#import <Foundation/Foundation.h>
#include "libnjb.h"
#import "MyMutableArray.h"
#import "Track.h"
#import "DataFile.h"
#import "StatusDisplayer.h"
#import "NJBTransactionResult.h"
#import "Playlist.h"

@interface NJB : NSObject {
	IBOutlet StatusDisplayer *statusDisplayer;
	njb_t *njb;
	unsigned debug;
	statusTypes status;
	BOOL connected;
	unsigned long long totalDiskSpace;
	unsigned long long freeDiskSpace;
}

- (NJBTransactionResult *)connect;
- (void)disconnect;
- (void)setDebug:(unsigned)newDebug;
- (NSString *)ownerString;
- (statusTypes)status;
- (void)setStatus:(statusTypes)newStatus;
- (BOOL)isConnected;
- (MyMutableArray *)tracks;
- (MyMutableArray *)dataFiles;
- (MyMutableArray *)playlists;
- (NJBTransactionResult *)deleteTrack:(NSNumber *)trackID;
- (NJBTransactionResult *)uploadTrack:(Track *)track;
- (NJBTransactionResult *)downloadTrack:(Track *)track;
- (NJBTransactionResult *)changeTrackTag:(Track *)track;
- (NJBTransactionResult *)downloadFile:(DataFile *)dataFile;
- (NJBTransactionResult *)uploadFile:(DataFile *)dataFile;
- (NJBTransactionResult *)deleteFile:(NSNumber *)fileID;
- (unsigned long long)totalDiskSpace;
- (unsigned long long)freeDiskSpace;
- (NSCalendarDate *)jukeboxTime;
- (BOOL)isProtocol3Device;
- (NJBTransactionResult *)setOwnerString:(NSString *)owner;
- (NJBTransactionResult *)setBitmap:(NSString *)bitmapPath;
- (NJBTransactionResult *)setTime:(NSNumber *)timeIntervalSinceNow;
- (NJBTransactionResult *)updatePlaylist:(Playlist *)playlist;
- (NJBTransactionResult *)deletePlaylist:(Playlist *)playlist;
- (NSString *)productName;

int progress (u_int64_t sent, u_int64_t total, const char* buf, unsigned len, void *data);

@end
