//
//  WMATagger.m
//  XNJB
//
//  Created by Richard Low on 17/09/2004.
//  Copyright 2004 __MyCompanyName__. All rights reserved.
//

#import "WMATagger.h"
#include "wmaread.h"

@implementation WMATagger

- (id)init
{
	// can't be initialized
	return nil;
}

+ (Track *)readTrack:(NSString *)filename
{
	// check file exists
	NSFileManager *fileManager = [[NSFileManager alloc] init];
	// this is used below to get filesize
	NSDictionary *fileAttributes = [fileManager fileAttributesAtPath:filename traverseLink:YES];
	if (fileAttributes == nil)
		return nil;
	
	Track *track = [[Track alloc] init];
		
	[track setFilesize:[[fileAttributes objectForKey:NSFileSize] intValue]];
	[track setCodec:CODEC_WMA];
	[track setFullPath:filename];

	metadata_t meta;
	// make sure all pointers are NULL
	memset(&meta, 0, sizeof(metadata_t));
	meta.path = (gchar *)[filename fileSystemRepresentation];
	get_tag_for_wmafile(&meta);
	
	if (meta.title != NULL)
		[track setTitle:[NSString stringWithUTF8String:meta.title]];
	if (meta.artist != NULL)
		[track setArtist:[NSString stringWithUTF8String:meta.artist]];
	if (meta.album != NULL)
		[track setAlbum:[NSString stringWithUTF8String:meta.album]];
	if (meta.genre != NULL)
		[track setGenre:[NSString stringWithUTF8String:meta.genre]];
	[track setTrackNumber:meta.trackno];
	[track setYear:meta.year];
	[track setLength:meta.length];
	return [track autorelease];
}

@end
