//
//  MusicTab.h
//  XNJB
//

#import <Cocoa/Cocoa.h>
#import "MyFileTab.h"
#import "NJBTransactionResult.h"
#import "MyTableTab.h"

@interface MusicTab : MyFileTab
{
@private
	IBOutlet MyTableTab *playlistsTab;
	int previousTrackIndexSelected;
	NSDictionary *fileExtensionsToCodecsDictionary;
	activeObjects objectToSaveTrack;
	BOOL trackListUpToDate;
}
- (void)loadTracks;
- (NJBTransactionResult *)downloadTrackList;
- (void)copyTrackToNJB:(Track *)track;
- (void)copyTrackFromNJB:(Track *)track;
- (void)replaceTrack:(Track *)replace withTrack:(Track *)new;
- (void)writeTagToFile:(Track *)track;
- (NJBTransactionResult *)uploadTrack:(Track *)track;

@end
