//
//  Track.h
//  XNJB
//
//  Created by Richard Low on Sun Jul 18 2004.
//

#import <Foundation/Foundation.h>
#import "MyItem.h"

// these should be in numerical order of sorting that we'd like compareByCodec to use
typedef enum _codecTypes {CODEC_UNDEFINED = -1, CODEC_MP3 = 0, CODEC_WMA = 1, CODEC_WAV = 2} codecTypes;

@interface Track : MyItem {
@private
  NSString *title;
	NSString *album;
	NSString *artist;
	NSString *genre;
	NSString *filename;
	NSString *fullPath;
	unsigned length;
	unsigned trackNumber;
	unsigned year;
	codecTypes codec;
	unsigned filesize;
	// the njb track id for this track
	unsigned trackID;
}
- (id)initWithTrack:(Track *)track;
- (NSString *)title;
- (void)setTitle:(NSString *)newTitle;
- (NSString *)album;
- (void)setAlbum:(NSString *)newAlbum;
- (NSString *)artist;
- (void)setArtist:(NSString *)newArtist;
- (NSString *)genre;
- (void)setGenre:(NSString *)newGenre;
- (NSString *)filename;
- (void)setFilename:(NSString *)newFilename;
- (NSString *)fullPath;
- (void)setFullPath:(NSString *)newFullPath;
- (unsigned)length;
- (NSString *)lengthString;
- (void)setLength:(unsigned)newLength;
- (unsigned)trackNumber;
- (void)setYear:(unsigned)newYear;
- (unsigned)year;
- (void)setTrackNumber:(unsigned)newTrackNumber;
- (codecTypes)codec;
- (NSString *)codecString;
- (NSString *)njbCodec;
- (void)setCodec:(codecTypes)newCodec;
- (unsigned)filesize;
- (void)setTrackID:(unsigned)newTrackID;
- (unsigned)trackID;
- (NSString *)filesizeString;
- (void)setFilesize:(unsigned)newFilesize;
- (void)setValuesToTrack:(Track *)track;

- (NSComparisonResult)compareByTitle:(Track *)other;
+ (SEL)compareByTitleSelector;
- (NSComparisonResult)compareByAlbum:(Track *)other;
+ (SEL)compareByAlbumSelector;
- (NSComparisonResult)compareByArtist:(Track *)other;
+ (SEL)compareByArtistSelector;
- (NSComparisonResult)compareByGenre:(Track *)other;
+ (SEL)compareByGenreSelector;
- (NSComparisonResult)compareByLength:(Track *)other;
+ (SEL)compareByLengthSelector;
- (NSComparisonResult)compareByFilesize:(Track *)other;
+ (SEL)compareByFilesizeSelector;
- (NSComparisonResult)compareByCodec:(Track *)other;
+ (SEL)compareByCodecSelector;
- (NSComparisonResult)compareByTrackNumber:(Track *)other;
+ (SEL)compareByTrackNumberSelector;
- (NSComparisonResult)compareByYear:(Track *)other;
+ (SEL)compareByYearSelector;


@end
