//
//  Track.m
//  XNJB
//
//  Created by Richard Low on Sun Jul 18 2004.
//

/* the track object with tag informatioon
 * 
 */
#import "Track.h"
#import "FilesizeFormatter.h"
#import "MyMutableArray.h"

@implementation Track

// init/dealloc methods

- (id)init
{
	if (self = [super init])
	{
		// set all to sane values
		[self setTitle:@""];
		[self setArtist:@""];
		[self setAlbum:@""];
		[self setGenre:@""];
		[self setFilename:@""];
		[self setFullPath:@""];
		[self setTrackNumber:0];
		[self setYear:0];
		[self setFilesize:0];
		[self setLength:0];
		[self setCodec:CODEC_UNDEFINED];
		[self setTrackID:0];
	}
	return self;
}

- (id)initWithTrack:(Track *)track
{
	if (self = [super init])
	{
		[self setValuesToTrack:track];
	}
	return self;
}

- (void)dealloc
{
	[title release];
	[album release];
	[artist release];
	[genre release];
	[super dealloc];
}

// accessor methods
	
- (NSString *)title
{
	return title;
}

- (void)setTitle:(NSString *)newTitle
{
	if (newTitle == nil)
	{
		title = @"";
		[title release];
	}
	else
	{
		// get immutable copy
		newTitle = [newTitle copy];
		[title release];
		title = newTitle;
	}
}

- (NSString *)album
{
	return album;
}

- (void)setAlbum:(NSString *)newAlbum
{
	if (newAlbum == nil)
	{
		[album release];
		album = @"";
	}
	else
	{
		// get immutable copy
		newAlbum = [newAlbum copy];
		[album release];
		album = newAlbum;
	}
}

- (NSString *)artist
{
	return artist;
}

- (void)setArtist:(NSString *)newArtist
{
	if (newArtist == nil)
	{
		[artist release];
		artist = @"";
	}
	else
	{
		// get immutable copy
		newArtist = [newArtist copy];
		[artist release];
		artist = newArtist;
	}
}

- (NSString *)genre
{
	return genre;
}

- (void)setGenre:(NSString *)newGenre
{
	if (newGenre == nil)
	{
		[genre release];
		genre = @"";
	}
	else
	{
		// get immutable copy
		newGenre = [newGenre copy];
		[genre release];
		genre = newGenre;
	}
}

- (NSString *)filename
{
	return filename;
}

- (void)setFilename:(NSString *)newFilename
{
	if (newFilename == nil)
	{
		[filename release];
		filename = @"";
	}
	else
	{
		// get immutable copy
		newFilename = [newFilename copy];
		[filename release];
		filename = newFilename;
	}
}

- (NSString *)fullPath
{
	return fullPath;
}

- (void)setFullPath:(NSString *)newFullPath
{
	if (newFullPath == nil)
	{
		[fullPath release];
		fullPath = @"";
	}
	else
	{
		// get immutable copy
		newFullPath = [newFullPath copy];
		[fullPath release];
		fullPath = newFullPath;
	}
}

- (unsigned)length
{
	return length;
}

- (NSString *)lengthString
{
	// if length >= 24 hours then we just give the time modulo 24 hours
	NSDate *lengthDate = [NSDate dateWithTimeIntervalSinceReferenceDate:length];
	if (length >= 3600)
	{
		// we have hours
		return [lengthDate descriptionWithCalendarFormat:@"%H:%M:%S" timeZone:[NSTimeZone timeZoneForSecondsFromGMT:0] locale:nil];
	}
	else
		return [lengthDate descriptionWithCalendarFormat:@"%M:%S" timeZone:[NSTimeZone timeZoneForSecondsFromGMT:0] locale:nil];
}

- (void)setLength:(unsigned)newLength
{
	length = newLength;
}

- (unsigned)trackNumber
{
	return trackNumber;
}

- (void)setTrackNumber:(unsigned)newTrackNumber
{
	trackNumber = newTrackNumber;
}

- (codecTypes)codec
{
	return codec;
}

- (NSString *)njbCodec
{
	// is this a sensible default?
	if (codec == CODEC_UNDEFINED)
		return @"MP3";
	return [self codecString];
}

- (NSString *)codecString
{
	switch (codec)
	{
		case CODEC_UNDEFINED:
			return @"UNKNOWN";
			break;
	  case CODEC_MP3:
			return @"MP3";
			break;
		case CODEC_WMA:
			return @"WMA";
			break;
		case CODEC_WAV:
			return @"WAV";
			break;
		default:
			NSLog(@"Invalid codec in codecString, title %@", title);
			return nil;
	}
}

- (void)setCodec:(codecTypes)newCodec
{
	codec = newCodec;
}

- (unsigned)filesize
{
	return filesize;
}

- (NSString *)filesizeString
{
	return [FilesizeFormatter filesizeString:filesize];
}

- (void)setYear:(unsigned)newYear
{
	year = newYear;
}

- (unsigned)year
{
	return year;
}

- (void)setFilesize:(unsigned)newFilesize
{
	filesize = newFilesize;
}

- (unsigned)trackID
{
	return trackID;
}

- (void)setTrackID:(unsigned)newTrackID
{
	trackID = newTrackID;
}

/**********************/

- (void)setValuesToTrack:(Track *)track
{
	[self setTitle:[track title]];
	[self setArtist:[track artist]];
	[self setAlbum:[track album]];
	[self setGenre:[track genre]];
	[self setFilename:[track filename]];
	[self setFullPath:[track fullPath]];
	[self setTrackNumber:[track trackNumber]];
	[self setYear:[track year]];
	[self setFilesize:[track filesize]];
	[self setLength:[track length]];
	[self setCodec:[track codec]];
	[self setTrackID:[track trackID]];
}

- (NSString *)description
{
	return [NSString stringWithFormat:@"Title: %@, Artist: %@, Album: %@, Genre: %@, Length: %@, Track No: %d, Codec: %@, Filesize: %@, Track ID: %d, Year: %d, Filename: %@, Fullpath: %@",
		title, artist, album, genre, [self lengthString], trackNumber,
		[self codecString], [self filesizeString], trackID, year, filename, fullPath];
}

/* searches title, album, artist and genre for the string
 * search. Case insensitive
 */
- (BOOL)matchesString:(NSString *)search
{
	NSRange result = [title rangeOfString:search options:NSCaseInsensitiveSearch];
	if (result.location == NSNotFound)
	{
		result = [album rangeOfString:search options:NSCaseInsensitiveSearch];
		if (result.location == NSNotFound)
		{
			result = [artist rangeOfString:search options:NSCaseInsensitiveSearch];
			if (result.location == NSNotFound)
			{
				result = [genre rangeOfString:search options:NSCaseInsensitiveSearch];
				if (result.location == NSNotFound)
					return NO;
			}
		}
	}
	return YES;	
}

// comparison methods

- (NSComparisonResult)compareByFilesize:(Track *)other
{
	return [self compareUnsignedInts:filesize withOther:[other filesize] withItem:other withSortSelector:@selector(compareByFilesize:)];
}

+ (SEL)compareByFilesizeSelector
{
	return @selector(compareByFilesize:);
}

- (NSComparisonResult)compareByLength:(Track *)other {
	return [self compareUnsignedInts:length withOther:[other length] withItem:other withSortSelector:@selector(compareByLength:)];
}

+ (SEL)compareByLengthSelector
{
	return @selector(compareByLength:);
}

- (NSComparisonResult)compareByTitle:(Track *)other
{
	return [self compareStrings:title withOther:[other title] withItem:other withSortSelector:@selector(compareByTitle:)];
}

+ (SEL)compareByTitleSelector
{
	return @selector(compareByTitle:);
}

- (NSComparisonResult)compareByArtist:(Track *)other
{
	return [self compareStrings:artist withOther:[other artist] withItem:other withSortSelector:@selector(compareByArtist:)];
}

+ (SEL)compareByArtistSelector
{
	return @selector(compareByArtist:);
}

- (NSComparisonResult)compareByAlbum:(Track *)other
{
	return [self compareStrings:album withOther:[other album] withItem:other withSortSelector:@selector(compareByAlbum:)];
}

+ (SEL)compareByAlbumSelector
{
	return @selector(compareByAlbum:);
}

- (NSComparisonResult)compareByGenre:(Track *)other
{
	return [self compareStrings:genre withOther:[other genre] withItem:other withSortSelector:@selector(compareByGenre:)];
}

+ (SEL)compareByGenreSelector
{
	return @selector(compareByGenre:);
}

- (NSComparisonResult)compareByCodec:(Track *)other {
	return [self compareUnsignedInts:codec withOther:[other codec] withItem:other withSortSelector:@selector(compareByCodec:)];
}

+ (SEL)compareByCodecSelector
{
	return @selector(compareByCodec:);
}

- (NSComparisonResult)compareByTrackNumber:(Track *)other {
	return [self compareUnsignedInts:trackNumber withOther:[other trackNumber] withItem:other withSortSelector:@selector(compareByTrackNumber:)];
}

+ (SEL)compareByTrackNumberSelector
{
	return @selector(compareByTrackNumber:);
}

- (NSComparisonResult)compareByYear:(Track *)other
{
	return [self compareUnsignedInts:year withOther:[other year] withItem:other withSortSelector:@selector(compareByYear:)];
}

+ (SEL)compareByYearSelector
{
	return @selector(compareByYear:);
}

@end
