//
//  NJB.h
//  XNJB
//
//  Created by Richard Low on Wed Jul 21 2004.
//

#import <Foundation/Foundation.h>
#include "libnjb.h"
#import "Track.h"
#import "DataFile.h"
#import "StatusDisplayer.h"
#import "NJBTransactionResult.h"
#import "Playlist.h"
#import "Directory.h"

@interface NJB : NSObject {
	IBOutlet StatusDisplayer *statusDisplayer;
	njb_t *njb;
	unsigned debug;
	statusTypes status;
	BOOL connected;
	unsigned long long totalDiskSpace;
	unsigned long long freeDiskSpace;
	NSMutableArray *cachedTrackList;
	// this is set when we are getting the track list so
	// we know the cache should not be used
	BOOL downloadingTracks;
	njb_t njbs[NJB_MAX_DEVICES];
	BOOL turbo;
	
	NSString *deviceString;
	NSString *firmwareVersionString;
	NSString *deviceIDString;
	NSString *deviceVersionString;
}

- (NJBTransactionResult *)connect;
- (void)disconnect;
- (void)setDebug:(unsigned)newDebug;
- (NSString *)ownerString;
- (statusTypes)status;
- (void)setStatus:(statusTypes)newStatus;
- (BOOL)isConnected;
- (NSMutableArray *)tracks;
- (NSMutableArray *)cachedTrackList;
- (Directory *)dataFiles;
- (NSMutableArray *)playlists;
- (NJBTransactionResult *)deleteTrack:(Track *)track;
- (NJBTransactionResult *)uploadTrack:(Track *)track;
- (NJBTransactionResult *)downloadTrack:(Track *)track;
- (NJBTransactionResult *)changeTrackTagTo:(Track *)newTrack from:(Track *)oldTrack;
- (NJBTransactionResult *)downloadFile:(DataFile *)dataFile;
- (NJBTransactionResult *)uploadFile:(DataFile *)dataFile toFolder:(NSString *)path;
- (NJBTransactionResult *)deleteFile:(NSNumber *)fileID;
- (unsigned long long)totalDiskSpace;
- (unsigned long long)freeDiskSpace;
- (NSCalendarDate *)jukeboxTime;
- (BOOL)isProtocol3Device;
- (NJBTransactionResult *)setOwnerString:(NSString *)owner;
- (NJBTransactionResult *)setBitmap:(NSString *)bitmapPath;
- (NJBTransactionResult *)setTime:(NSNumber *)timeIntervalSinceNow;
- (NJBTransactionResult *)updatePlaylist:(Playlist *)playlist;
- (NJBTransactionResult *)deletePlaylist:(Playlist *)playlist;
- (NSString *)productName;
- (NJBTransactionResult *)changeTrackTagTo:(Track *)newTrack from:(Track *)oldTrack;
- (NJBTransactionResult *)createFolder:(Directory *)dir inDir:(NSString *)path;
- (NSString *)deviceString;
- (NSString *)firmwareVersionString;
- (NSString *)deviceIDString;
- (NSString *)deviceVersionString;
- (void)storeDeviceString;
- (void)storeFirmwareVersionString;
- (void)storeDeviceIDString;
- (void)storeDeviceVersionString;
- (int)batteryLevel;
- (NSString *)batteryStatus;
- (void)setTurbo:(BOOL) newTurbo;

int progress (u_int64_t sent, u_int64_t total, const char* buf, unsigned len, void *data);

@end
