//
//  NJBTransactionResult.m
//  XNJB
//
//  Created by Richard Low on Mon Jul 26 2004.
//

/* The object passed around to indicate
 * success or failure of some communication with
 * the NJB. Really is just a BOOL.
 */

#import "NJBTransactionResult.h"

@implementation NJBTransactionResult

// init/dealloc methods

- (id)initWithSuccess:(BOOL)newSuccess
{
	return [self initWithSuccess:newSuccess resultString:@""];
}

- (id)initWithSuccess:(BOOL)newSuccess resultString:(NSString *)newResultString
{
	if (self = [super init])
	{
		[self setSuccess:newSuccess];
		[self setResultString:newResultString];
	}
	return self;
}

- (void)dealloc
{
	[resultString release];
	[super dealloc];
}

// accessor methods

- (void)setSuccess:(BOOL)newSuccess
{
	success = newSuccess;
}

- (BOOL)success
{
	return success;
}

- (void)setResultString:(NSString *)newResultString
{
	if (newResultString == nil)
		newResultString = @"";
	// get immutable copy
	newResultString = [NSString stringWithString:newResultString];
	[newResultString retain];
	[resultString release];
	resultString = newResultString;
}

- (NSString *)resultString
{
	return resultString;
}

@end
