# SPEC file for libnjb, primary target is the Fedora Extras
# RPM repository.
#
# For testing a certain distribution, rely on macros that
# you define in your ".rpmmacros" file. For example, for
# test building a Fedora Extras package, define the following
# two macros in .rpmmacros:
#
# %dist .fc4
# %fedora 4
#

Name:		libnjb
Version:	2.2.1
Release:	7%{?dist}
Summary:	A software library for talking to the Creative Nomad Jukeboxes and Dell DJs
URL:		http://libnjb.sourceforge.net/

Group:		System Environment/Libraries
Source:		http://download.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
License:	BSD
Requires:	hotplug
BuildRequires:	libusb-devel
BuildRequires:	zlib-devel
BuildRequires:	ncurses-devel
BuildRequires:	doxygen

%description
This package provides a software library for communicating with the
Creative Nomad Jukebox line of MP3 players.

%package examples
Summary:        Example programs for libnjb
Group:          Applications/Multimedia
Requires:       %{name} = %{version}-%{release}

%description examples
This package provides example programs for communicating with the
Creative Nomad Jukebox and Dell DJ line of MP3 players.

%package devel
Summary:        Development files for libnjb
Group:          System Environment/Libraries
Requires:       %{name} = %{version}-%{release}
# doc subpackage removed in newer releases, and included
# in the -devel package.
Provides:	libnjb-doc
Obsoletes:	libnjb-doc <= 2.2-1
Requires:	libusb-devel
Requires:	zlib-devel
Requires:	ncurses-devel

%description devel
This package provides development files for the libnjb
library for Creative Nomad/Zen/Jukebox and Dell DJ line of MP3 players.

%prep
%setup -q

%build
%configure --disable-static --program-prefix=njb-
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall
# Remove libtool archive remnant
rm -f $RPM_BUILD_ROOT%{_libdir}/libnjb.la
# Install hotplug scripts so they are up to date
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/hotplug/usb
install -p -m 755 nomadjukebox $RPM_BUILD_ROOT%{_sysconfdir}/hotplug/usb
install -p -m 644 nomad.usermap $RPM_BUILD_ROOT%{_sysconfdir}/hotplug/usb
# Copy documentation to a good place
install -p -m 644 AUTHORS ChangeLog ChangeLog-old FAQ \
INSTALL LICENSE HACKING $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%{_libdir}/*.so.*
%config(noreplace) %{_sysconfdir}/hotplug/usb/*

%files examples
%defattr(-, root, root)
%{_bindir}/*

%files devel
%defattr(-, root, root)
%{_libdir}/*.so
%dir %{_docdir}/%{name}-%{version}
%{_docdir}/%{name}-%{version}/*
%{_includedir}/*.h
%{_libdir}/pkgconfig/*.pc


%changelog
* Wed Aug 11 2005 Linus Walleij <triad@df.lth.se> 2.2.1-7
- Forgot one extraneous docdir, removing it.
* Wed Aug 10 2005 Linus Walleij <triad@df.lth.se> 2.2.1-6
- Even more fixes after more feedback from Michael.
* Tue Aug 9 2005 Linus Walleij <triad@df.lth.se> 2.2.1-5
- More fixes after feedback from Michael Schwendt.
* Sun Aug 7 2005 Linus Walleij <triad@df.lth.se> 2.2.1-4
- More fixes after feedback from Ralf Corsepius.
* Sat Aug 6 2005 Linus Walleij <triad@df.lth.se> 2.2.1-3
- Remove unnecessary macros.
* Mon Aug 1 2005 Linus Walleij <triad@df.lth.se> 2.2.1-2
- More work on Fedora compliance.
* Sat Jul 30 2005 Linus Walleij <triad@df.lth.se> 2.2.1-1
- Fedora extrafication, created a -devel package.
* Mon Jun 27 2005 Linus Walleij <triad@df.lth.se> 2.2-1
- Fixed a lot of RPM modernization for 2.2 release
* Mon May 23 2005 Linus Walleij <triad@df.lth.se> 2.1.2-1
- Interrim 2.1.2 release. Fixed program prefix.
* Fri May 13 2005 Linus Walleij <triad@df.lth.se> 2.1.1-1
- Interrim 2.1.1 release. Fixed library versioning.
* Tue May 10 2005 Linus Walleij <triad@df.lth.se> 2.1-1
- Final 2.1 release. Removed the checkings for old hotplug versions.
* Fri Mar 4 2005 Ed Welch <ed_welch@inbox.net> 2.0-1mdk
- Mandrake rpm for final 2.0 release.
* Wed Mar 2 2005 Linus Walleij <triad@df.lth.se> 2.0-1
- Final 2.0 release.
* Mon Feb 21 2005 Linus Walleij <triad@df.lth.se> 2.0-0.RC1
- Release candidate 1 for 2.0.
* Tue Feb 8 2005 Linus Walleij <triad@df.lth.se> 2.0-0.20050208
- Third CVS snapshot for the pre-2.0 series.
* Thu Jan 20 2005 Linus Walleij <triad@df.lth.se> 2.0-0.20050120
- Second CVS snapshot for the pre-2.0 series.
* Mon Jan 10 2005 Linus Walleij <triad@df.lth.se> 2.0-0.20050110
- A CVS snapshot for the first pre-2.0 series.
* Tue Nov 30 2004 Linus Walleij <triad@df.lth.se> 1.3-0.20041130
- A CVS snapshot for the new API and all.
* Wed Sep 29 2004 Linus Walleij <triad@df.lth.se> 1.2-0.20040929
- A CVS snapshot, much needed, which also works
* Fri Sep 24 2004 Linus Walleij <triad@df.lth.se> 1.2-0.20040924
- A CVS snapshot, much needed.
* Tue May 25 2004 Linus Walleij <triad@df.lth.se> 1.1-1
- Added hook to redistribute pkgconfig module
* Wed Apr 25 2004 Linus Walleij <triad@df.lth.se> 1.1-1
- Final 1.1 release!
* Wed Apr 21 2004 Linus Walleij <triad@df.lth.se> 1.0.2-0.20040421
- A new CVS snapshot.
* Fri Apr 9 2004 Linus Walleij <triad@df.lth.se> 1.0.2-0.20040409
- A new CVS snapshot.
* Sun Feb 22 2004 Linus Walleij <triad@df.lth.se> 1.0.2-0.20040222
- A new CVS snapshot. Adressing several bugs.
* Fri Jan 9 2004 Linus Walleij <triad@df.lth.se> 1.0.1-0.20040109
- A new CVS release adressing bugs, better numbering scheme
* Tue Dec 9 2003 Linus Walleij <triad@df.lth.se> 1.0.1-1
- Addressed some issues in 1.0
* Tue Dec 9 2003 Linus Walleij <triad@df.lth.se> 1.0-2
- Second package for samples
* Sat Dec 6 2003 Linus Walleij <triad@df.lth.se> 1.0-1
- Final 1.0 release
* Sun Aug 17 2003 Linus Walleij <triad@df.lth.se> 1.1.0b-6
- Seventh RPM
* Sun Aug 17 2003 Linus Walleij <triad@df.lth.se> 1.1.0b-5
- Sixth RPM
* Thu Jul 31 2003 Linus Walleij <triad@df.lth.se> 1.1.0b-4
- Fifth RPM
* Wed Jun 11 2003 Linus Walleij <triad@df.lth.se> 1.1.0b-3
- Fourth RPM.
* Mon Apr 21 2003 Linus Walleij <triad@df.lth.se> 1.1.0b-2
- Third RPM, big improvements in hotplug installation.
* Sun Mar 30 2003 Linus Walleij <triad@df.lth.se> 1.1.0b
- Second CVS RPM
* Thu Dec 26 2002 Dwight Engen <dengen40@yahoo.com> 0.9.1
- First RPM'ed
