//
//  Track.m
//  XNJB
//
//  Created by Richard Low on Sun Jul 18 2004.
//

/* the track object with tag informatioon
 * 
 */
#import "Track.h"
#import "FilesizeFormatter.h"

@implementation Track

// init/dealloc methods

- (id)init
{
	if (self = [super init])
	{
		// set all to sane values
		[self setTitle:@""];
		[self setArtist:@""];
		[self setAlbum:@""];
		[self setGenre:@""];
		//[self setFilename:@""];
		[self setFullPath:@""];
		[self setTrackNumber:0];
		[self setYear:0];
		[self setFilesize:0];
		[self setLength:0];
		[self setCodec:CODEC_UNDEFINED];
	}
	return self;
}

- (id)initWithTrack:(Track *)track
{
	if (self = [super init])
	{
		[self setValuesToTrack:track];
	}
	return self;
}

- (void)dealloc
{
	[title release];
	[album release];
	[artist release];
	[genre release];
	[super dealloc];
}

// accessor methods
	
- (NSString *)title
{
	return title;
}

- (void)setTitle:(NSString *)newTitle
{
	if (newTitle == nil)
		newTitle = @"";
	// get immutable copy
	newTitle = [NSString stringWithString:newTitle];
	[newTitle retain];
	[title release];
	title = newTitle;
}

- (NSString *)album
{
	return album;
}

- (void)setAlbum:(NSString *)newAlbum
{
	if (newAlbum == nil)
		newAlbum = @"";
	// get immutable copy
	newAlbum = [NSString stringWithString:newAlbum];
	[newAlbum retain];
	[album release];
	album = newAlbum;
}

- (NSString *)artist
{
	return artist;
}

- (void)setArtist:(NSString *)newArtist
{
	if (newArtist == nil)
		newArtist = @"";
	// get immutable copy
	newArtist = [NSString stringWithString:newArtist];
	[newArtist retain];
	[artist release];
	artist = newArtist;
}

- (NSString *)genre
{
	return genre;
}

- (void)setGenre:(NSString *)newGenre
{
	if (newGenre == nil)
		newGenre = @"";
	// get immutable copy
	newGenre = [NSString stringWithString:newGenre];
	[newGenre retain];
	[genre release];
	genre = newGenre;
}

- (NSString *)filename
{
	return filename;
}

- (void)setFilename:(NSString *)newFilename
{
	if (newFilename == nil)
		newFilename = @"";
	// get immutable copy
	newFilename = [NSString stringWithString:newFilename];
	[newFilename retain];
	[filename release];
	filename = newFilename;
}

- (NSString *)fullPath
{
	return fullPath;
}

- (void)setFullPath:(NSString *)newFullPath
{
	if (newFullPath == nil)
		newFullPath = @"";
	// get immutable copy
	newFullPath = [NSString stringWithString:newFullPath];
	[newFullPath retain];
	[fullPath release];
	fullPath = newFullPath;
}

- (unsigned)length
{
	return length;
}

- (NSString *)lengthString
{
	// if length >= 24 hours then we just give the time modulo 24 hours
	NSDate *lengthDate = [NSDate dateWithTimeIntervalSinceReferenceDate:length];
	if (length >= 3600)
	{
		// we have hours
		return [lengthDate descriptionWithCalendarFormat:@"%H:%M:%S" timeZone:[NSTimeZone timeZoneForSecondsFromGMT:0] locale:nil];
	}
	else
		return [lengthDate descriptionWithCalendarFormat:@"%M:%S" timeZone:[NSTimeZone timeZoneForSecondsFromGMT:0] locale:nil];
}

- (void)setLength:(unsigned)newLength
{
	length = newLength;
}

- (unsigned)trackNumber
{
	return trackNumber;
}

- (void)setTrackNumber:(unsigned)newTrackNumber
{
	trackNumber = newTrackNumber;
}

- (codecTypes)codec
{
	return codec;
}

- (NSString *)njbCodec
{
	// is this a sensible default?
	if (codec == CODEC_UNDEFINED)
		return @"MP3";
	return [self codecString];
}

- (NSString *)codecString
{
	switch (codec)
	{
		case CODEC_UNDEFINED:
			return @"UNKNOWN";
			break;
	  case CODEC_MP3:
			return @"MP3";
			break;
		case CODEC_WMA:
			return @"WMA";
			break;
		case CODEC_WAV:
			return @"WAV";
			break;
		case CODEC_AA:
			return @"AA";
			break;
		default:
			NSLog(@"Invalid codec in codecString, title %@", title);
			return nil;
	}
}

- (void)setCodec:(codecTypes)newCodec
{
	codec = newCodec;
}

- (unsigned long long)filesize
{
	return filesize;
}

- (NSString *)filesizeString
{
	return [FilesizeFormatter filesizeString:filesize];
}

- (void)setYear:(unsigned)newYear
{
	year = newYear;
}

- (unsigned)year
{
	return year;
}

- (void)setFilesize:(unsigned long long)newFilesize
{
	filesize = newFilesize;
}

/**********************/

- (void)setValuesToTrack:(Track *)track
{
	[self setTitle:[track title]];
	[self setArtist:[track artist]];
	[self setAlbum:[track album]];
	[self setGenre:[track genre]];
	[self setFilename:[track filename]];
	[self setFullPath:[track fullPath]];
	[self setTrackNumber:[track trackNumber]];
	[self setYear:[track year]];
	[self setFilesize:[track filesize]];
	[self setLength:[track length]];
	[self setCodec:[track codec]];
	[self setItemID:[track itemID]];
}

- (NSString *)description
{
	return [NSString stringWithFormat:@"Title: %@, Artist: %@, Album: %@, Genre: %@, Length: %@, Track No: %d, Codec: %@, Filesize: %@, Track ID: %d, Year: %d, Filename: %@, Fullpath: %@",
		title, artist, album, genre, [self lengthString], trackNumber,
		[self codecString], [self filesizeString], itemID, year, filename, fullPath];
}

/* searches title, album, artist and genre for the string
 * search. Case insensitive
 */
- (BOOL)matchesString:(NSString *)search
{
	NSRange result = [title rangeOfString:search options:NSCaseInsensitiveSearch];
	if (result.location == NSNotFound)
	{
		result = [album rangeOfString:search options:NSCaseInsensitiveSearch];
		if (result.location == NSNotFound)
		{
			result = [artist rangeOfString:search options:NSCaseInsensitiveSearch];
			if (result.location == NSNotFound)
			{
				result = [genre rangeOfString:search options:NSCaseInsensitiveSearch];
				if (result.location == NSNotFound)
					return NO;
			}
		}
	}
	return YES;	
}

- (NSComparisonResult)compareByLength:(Track *)other
{
	return [self compareUnsignedInts:length withOther:[other length]];
}

/* this compares the two unsigned ints mine and theirs
 */
- (NSComparisonResult)compareUnsignedInts:(unsigned)mine withOther:(unsigned)theirs
{
	if (mine == theirs)
			return NSOrderedSame;
	else if (mine < theirs)
		return NSOrderedAscending;
	else
		return NSOrderedDescending;
}

@end
