//
//  MyItem.m
//  XNJB
//
//  Created by Richard Low on 07/09/2004.
//

/* This class is used for the 
 * sortable elements of the array.
 * Also declares a method matchesString to see
 * if this item contains a string. This is to be
 * implemented by super classes (e.g. Track or DataFile).
 */

#import "MyItem.h"

@implementation MyItem

- (id)init
{
	if (self = [super init])
	{
		[self setItemID:0];
	}
	return self;
}

/* To be implemented by super class.
 * Method to search self for NSString search
 */
- (BOOL)matchesString:(NSString *)search
{
	return YES;
}

- (void)setItemID:(unsigned)newItemID
{
	itemID = newItemID;
}

- (unsigned)itemID
{
	return itemID;
}

@end
